(globalThis.TURBOPACK || (globalThis.TURBOPACK = [])).push([typeof document === "object" ? document.currentScript : undefined,
"[project]/src/components/PartnerCard.tsx [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "PartnerCard",
    ()=>PartnerCard
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/next/dist/compiled/react/jsx-dev-runtime.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/next/dist/compiled/react/index.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$image$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/next/image.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/src/lib/color-theme.ts [app-client] (ecmascript)");
;
var _s = __turbopack_context__.k.signature();
"use client";
;
;
;
function getPositionLabel(index, positionLabels) {
    if (index < positionLabels.length) {
        return positionLabels[index];
    }
    // Fallback for positions beyond the provided labels
    // This is a generic fallback - ideally all positions should be in translations
    const fallbackSuffixes = {
        1: "st",
        2: "nd",
        3: "rd"
    };
    const suffix = fallbackSuffixes[index % 10] || "th";
    return `${index + 1}${suffix} Option`;
}
/**
 * Gets badge color based on position index and theme
 * Uses first color (buttonBadge) with variations for different positions
 */ function getBadgeColors(index, theme) {
    const colorTheme = (0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["getColorTheme"])(theme);
    // Create variations of the buttonBadge color for different positions
    // Use lighter/darker variations of the first color
    const baseColor = colorTheme.buttonBadge;
    // Helper to lighten/darken color
    const lighten = (hex, percent)=>{
        const num = parseInt(hex.replace("#", ""), 16);
        const r = Math.min(255, (num >> 16) + Math.round(255 * percent));
        const g = Math.min(255, (num >> 8 & 0x00FF) + Math.round(255 * percent));
        const b = Math.min(255, (num & 0x0000FF) + Math.round(255 * percent));
        return `#${(r << 16 | g << 8 | b).toString(16).padStart(6, '0')}`;
    };
    const variations = [
        {
            from: baseColor,
            to: lighten(baseColor, 0.15)
        },
        {
            from: lighten(baseColor, -0.1),
            to: baseColor
        },
        {
            from: baseColor,
            to: lighten(baseColor, -0.1)
        },
        {
            from: lighten(baseColor, 0.1),
            to: lighten(baseColor, -0.05)
        },
        {
            from: lighten(baseColor, -0.15),
            to: lighten(baseColor, 0.05)
        }
    ];
    const variation = variations[index % variations.length];
    return {
        fromColor: variation.from,
        toColor: variation.to
    };
}
function PartnerCard({ partner, affiliateHref, index = 0, translations, language, theme }) {
    _s();
    const [isVisible, setIsVisible] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useState"])(false);
    // Get color theme based on theme
    const colorTheme = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useMemo"])({
        "PartnerCard.useMemo[colorTheme]": ()=>(0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["getColorTheme"])(theme)
    }["PartnerCard.useMemo[colorTheme]"], [
        theme
    ]);
    // Memoize animation delay to prevent recalculation
    const animationDelay = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useMemo"])({
        "PartnerCard.useMemo[animationDelay]": ()=>index * 50
    }["PartnerCard.useMemo[animationDelay]"], [
        index
    ]);
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useEffect"])({
        "PartnerCard.useEffect": ()=>{
            const timer = setTimeout({
                "PartnerCard.useEffect.timer": ()=>{
                    setIsVisible(true);
                }
            }["PartnerCard.useEffect.timer"], animationDelay);
            return ({
                "PartnerCard.useEffect": ()=>clearTimeout(timer)
            })["PartnerCard.useEffect"];
        }
    }["PartnerCard.useEffect"], [
        animationDelay
    ]);
    // Memoize position label using translations
    const positionLabel = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useMemo"])({
        "PartnerCard.useMemo[positionLabel]": ()=>getPositionLabel(index, translations.positionLabels)
    }["PartnerCard.useMemo[positionLabel]"], [
        index,
        translations.positionLabels
    ]);
    // Memoize badge colors based on position and theme
    const badgeColors = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useMemo"])({
        "PartnerCard.useMemo[badgeColors]": ()=>getBadgeColors(index, theme)
    }["PartnerCard.useMemo[badgeColors]"], [
        index,
        theme
    ]);
    // Generate vote count based on partner name (random but consistent per partner)
    const voteCount = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useMemo"])({
        "PartnerCard.useMemo[voteCount]": ()=>{
            // Create a simple hash from partner name for consistent "random" value
            let hash = 0;
            for(let i = 0; i < partner.name.length; i++){
                const char = partner.name.charCodeAt(i);
                hash = (hash << 5) - hash + char;
                hash = hash & hash; // Convert to 32-bit integer
            }
            // Generate a number between 1.5k and 5k based on hash
            const baseCount = 1500 + Math.abs(hash) % 3500; // Range: 1500-5000
            if (baseCount >= 1000) {
                const kValue = (baseCount / 1000).toFixed(1);
                // Remove .0 if it's a whole number
                return kValue.endsWith('.0') ? `${kValue.replace('.0', '')}k` : `${kValue}k`;
            }
            return `${baseCount}+`;
        }
    }["PartnerCard.useMemo[voteCount]"], [
        partner.name
    ]);
    // Memoize click handler to prevent recreation on each render
    const handleClick = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useCallback"])({
        "PartnerCard.useCallback[handleClick]": async ()=>{
            // Track click asynchronously without blocking navigation
            try {
                await fetch('/api/clicks', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json'
                    },
                    body: JSON.stringify({
                        partnerName: partner.name
                    })
                });
            } catch (error) {
                // Silently fail - don't block user navigation
                console.error('Failed to track click:', error);
            }
        }
    }["PartnerCard.useCallback[handleClick]"], [
        partner.name
    ]);
    return /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("article", {
        className: `group relative flex flex-col overflow-hidden transition-all duration-500 ease-out ${isVisible ? "translate-y-0 opacity-100" : "translate-y-4 opacity-0"} hover:-translate-y-3 hover:scale-[1.02] focus-within:-translate-y-3 focus-within:scale-[1.02] active:scale-[0.99]`,
        style: {
            padding: '3px',
            borderRadius: '1rem',
            boxShadow: `0 4px 12px 0 ${(0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.cardBackground, 0.3)}, 0 0 0 1px ${(0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.buttonBadge, 0.1)}`
        },
        onMouseEnter: (e)=>{
            e.currentTarget.style.boxShadow = `0 24px 48px -12px ${(0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.buttonBadge, 0.2)}, 0 0 0 1px ${(0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.buttonBadge, 0.2)}`;
        },
        onMouseLeave: (e)=>{
            e.currentTarget.style.boxShadow = `0 4px 12px 0 ${(0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.cardBackground, 0.3)}, 0 0 0 1px ${(0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.buttonBadge, 0.1)}`;
        },
        onFocus: (e)=>{
            e.currentTarget.style.boxShadow = `0 24px 48px -12px ${(0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.buttonBadge, 0.2)}, 0 0 0 1px ${(0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.buttonBadge, 0.2)}`;
        },
        onBlur: (e)=>{
            e.currentTarget.style.boxShadow = `0 4px 12px 0 ${(0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.cardBackground, 0.3)}, 0 0 0 1px ${(0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.buttonBadge, 0.1)}`;
        },
        children: [
            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                className: "absolute opacity-80 sm:opacity-90",
                style: {
                    top: '-3px',
                    left: '-3px',
                    right: '-3px',
                    bottom: '-3px',
                    backgroundImage: `linear-gradient(90deg, ${(0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.buttonBadge, 0.3)}, ${(0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.buttonBadge, 0.5)}, ${(0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.buttonBadge, 0.3)}, ${(0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.buttonBadge, 0.5)})`,
                    backgroundSize: '200% 100%',
                    animation: 'shimmer-border 3s ease-in-out infinite',
                    borderRadius: '1rem',
                    zIndex: 0
                }
            }, void 0, false, {
                fileName: "[project]/src/components/PartnerCard.tsx",
                lineNumber: 154,
                columnNumber: 7
            }, this),
            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                className: "relative z-10 h-full w-full p-1.5 sm:p-4",
                style: {
                    borderRadius: 'calc(1rem - 3px)',
                    background: `linear-gradient(to bottom right, rgba(0, 0, 0, 0.98), ${(0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.cardBackground, 0.95)}, rgba(0, 0, 0, 0.98))`
                },
                children: [
                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                        className: "absolute inset-0 sm:opacity-0 transition-all duration-500 group-hover:opacity-100 z-0",
                        style: {
                            background: `linear-gradient(to bottom right, ${(0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.buttonBadge, 0.1)}, ${(0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.buttonBadge, 0.05)}, ${(0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.buttonBadge, 0.1)})`
                        }
                    }, void 0, false, {
                        fileName: "[project]/src/components/PartnerCard.tsx",
                        lineNumber: 178,
                        columnNumber: 7
                    }, this),
                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                        className: "absolute -inset-1 rounded-2xl sm:opacity-0 blur-xl transition-all duration-500 group-hover:opacity-100 sm:rounded-3xl z-0",
                        style: {
                            background: `linear-gradient(to right, ${(0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.buttonBadge, 0.15)}, ${(0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.buttonBadge, 0.12)}, ${(0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.buttonBadge, 0.15)})`
                        }
                    }, void 0, false, {
                        fileName: "[project]/src/components/PartnerCard.tsx",
                        lineNumber: 186,
                        columnNumber: 7
                    }, this),
                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                        className: "absolute top-3 left-3 h-1 w-1 rounded-full sm:opacity-0 transition-all duration-500 group-hover:opacity-100 animate-pulse z-0",
                        style: {
                            backgroundColor: (0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.buttonBadge, 0.6),
                            boxShadow: `0 0 6px ${colorTheme.buttonBadge}`,
                            animationDelay: `${index * 100}ms`
                        }
                    }, void 0, false, {
                        fileName: "[project]/src/components/PartnerCard.tsx",
                        lineNumber: 194,
                        columnNumber: 7
                    }, this),
                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                        className: "absolute top-6 right-4 h-1.5 w-1.5 rounded-full sm:opacity-0 transition-all duration-500 group-hover:opacity-100 animate-pulse z-0",
                        style: {
                            backgroundColor: (0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.buttonBadge, 0.6),
                            boxShadow: `0 0 8px ${colorTheme.buttonBadge}`,
                            animationDelay: `${index * 150}ms`
                        }
                    }, void 0, false, {
                        fileName: "[project]/src/components/PartnerCard.tsx",
                        lineNumber: 202,
                        columnNumber: 7
                    }, this),
                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                        className: "absolute bottom-16 left-1/2 h-1 w-1 rounded-full sm:opacity-0 transition-all duration-500 group-hover:opacity-100 animate-pulse z-0",
                        style: {
                            backgroundColor: (0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.buttonBadge, 0.6),
                            boxShadow: `0 0 6px ${colorTheme.buttonBadge}`,
                            animationDelay: `${index * 200}ms`
                        }
                    }, void 0, false, {
                        fileName: "[project]/src/components/PartnerCard.tsx",
                        lineNumber: 210,
                        columnNumber: 7
                    }, this),
                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                        className: "absolute top-1/2 right-3 h-1 w-1 rounded-full sm:opacity-0 transition-all duration-500 group-hover:opacity-100 animate-pulse z-0",
                        style: {
                            backgroundColor: (0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.buttonBadge, 0.5),
                            boxShadow: `0 0 5px ${colorTheme.buttonBadge}`,
                            animationDelay: `${index * 250}ms`
                        }
                    }, void 0, false, {
                        fileName: "[project]/src/components/PartnerCard.tsx",
                        lineNumber: 218,
                        columnNumber: 7
                    }, this),
                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                        className: "absolute bottom-8 right-1/4 h-1 w-1 rounded-full sm:opacity-0 transition-all duration-500 group-hover:opacity-100 animate-pulse z-0",
                        style: {
                            backgroundColor: (0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.buttonBadge, 0.5),
                            boxShadow: `0 0 5px ${colorTheme.buttonBadge}`,
                            animationDelay: `${index * 300}ms`
                        }
                    }, void 0, false, {
                        fileName: "[project]/src/components/PartnerCard.tsx",
                        lineNumber: 226,
                        columnNumber: 7
                    }, this),
                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                        className: "absolute inset-0 -translate-x-full animate-shimmer sm:opacity-0 z-0",
                        style: {
                            background: `linear-gradient(to right, transparent, ${(0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.buttonBadge, 0.1)}, ${(0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.buttonBadge, 0.08)}, transparent)`
                        }
                    }, void 0, false, {
                        fileName: "[project]/src/components/PartnerCard.tsx",
                        lineNumber: 236,
                        columnNumber: 9
                    }, this),
                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                        className: "absolute inset-0 translate-x-full z-0",
                        style: {
                            background: `linear-gradient(to left, transparent, ${(0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.buttonBadge, 0.08)}, transparent)`,
                            animation: 'shimmer 4s ease-in-out infinite reverse',
                            animationDelay: '1.5s'
                        }
                    }, void 0, false, {
                        fileName: "[project]/src/components/PartnerCard.tsx",
                        lineNumber: 244,
                        columnNumber: 9
                    }, this),
                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                        className: "absolute inset-0 sm:opacity-0 transition-opacity duration-500 group-hover:opacity-100 z-0",
                        style: {
                            background: `linear-gradient(to bottom right, ${(0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.buttonBadge, 0.03)}, transparent, ${(0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.buttonBadge, 0.03)})`
                        }
                    }, void 0, false, {
                        fileName: "[project]/src/components/PartnerCard.tsx",
                        lineNumber: 254,
                        columnNumber: 9
                    }, this),
                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                        className: "absolute top-0 left-0 right-0 z-20",
                        children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                            className: "relative px-2 py-1 sm:px-3 sm:py-1.5",
                            style: {
                                borderTopLeftRadius: 'calc(1rem - 3px)',
                                borderTopRightRadius: 'calc(1rem - 3px)',
                                background: `linear-gradient(to right, ${badgeColors.fromColor}, ${badgeColors.toColor})`
                            },
                            children: [
                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                    className: "absolute inset-0 bg-gradient-to-r from-white/25 via-transparent to-white/25",
                                    style: {
                                        borderTopLeftRadius: 'calc(1rem - 3px)',
                                        borderTopRightRadius: 'calc(1rem - 3px)'
                                    }
                                }, void 0, false, {
                                    fileName: "[project]/src/components/PartnerCard.tsx",
                                    lineNumber: 271,
                                    columnNumber: 11
                                }, this),
                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                    className: "relative flex items-center justify-between",
                                    children: [
                                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("span", {
                                            className: "rounded bg-white/35 backdrop-blur-md px-2 py-0.5 text-[9px] font-bold uppercase text-white drop-shadow-[0_2px_4px_rgba(0,0,0,0.8)] sm:px-2.5 sm:py-1 sm:text-[11px]",
                                            children: positionLabel
                                        }, void 0, false, {
                                            fileName: "[project]/src/components/PartnerCard.tsx",
                                            lineNumber: 274,
                                            columnNumber: 13
                                        }, this),
                                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                            className: "flex items-center gap-1 rounded bg-white/50 backdrop-blur-md px-2 py-0.5 sm:gap-1.5 sm:px-2.5 sm:py-1",
                                            style: {
                                                boxShadow: '0 2px 8px rgba(0,0,0,0.4)'
                                            },
                                            children: [
                                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                                    className: "flex items-center gap-0.5",
                                                    children: [
                                                        1,
                                                        2,
                                                        3,
                                                        4,
                                                        5
                                                    ].map((star)=>{
                                                        const normalizedRating = partner.rating / 10 * 5; // Convert 0-10 scale to 0-5 scale
                                                        const starFill = Math.max(0, Math.min(1, normalizedRating - (star - 1)));
                                                        const fillPercentage = starFill * 100;
                                                        const isFilled = starFill >= 1;
                                                        const isEmpty = starFill <= 0;
                                                        return /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("svg", {
                                                            className: "h-2.5 w-2.5 flex-shrink-0 drop-shadow-[0_1px_3px_rgba(0,0,0,0.9)] sm:h-3 sm:w-3",
                                                            viewBox: "0 0 20 20",
                                                            "aria-hidden": "true",
                                                            children: [
                                                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("defs", {
                                                                    children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("mask", {
                                                                        id: `starMask-${index}-${star}`,
                                                                        children: [
                                                                            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("rect", {
                                                                                x: "0",
                                                                                y: "0",
                                                                                width: "20",
                                                                                height: "20",
                                                                                fill: "black"
                                                                            }, void 0, false, {
                                                                                fileName: "[project]/src/components/PartnerCard.tsx",
                                                                                lineNumber: 290,
                                                                                columnNumber: 27
                                                                            }, this),
                                                                            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("rect", {
                                                                                x: "0",
                                                                                y: "0",
                                                                                width: `${fillPercentage * 0.2}`,
                                                                                height: "20",
                                                                                fill: "white"
                                                                            }, void 0, false, {
                                                                                fileName: "[project]/src/components/PartnerCard.tsx",
                                                                                lineNumber: 291,
                                                                                columnNumber: 27
                                                                            }, this)
                                                                        ]
                                                                    }, void 0, true, {
                                                                        fileName: "[project]/src/components/PartnerCard.tsx",
                                                                        lineNumber: 289,
                                                                        columnNumber: 25
                                                                    }, this)
                                                                }, void 0, false, {
                                                                    fileName: "[project]/src/components/PartnerCard.tsx",
                                                                    lineNumber: 288,
                                                                    columnNumber: 23
                                                                }, this),
                                                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("path", {
                                                                    fill: "#9ca3af",
                                                                    opacity: "0.5",
                                                                    d: "M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"
                                                                }, void 0, false, {
                                                                    fileName: "[project]/src/components/PartnerCard.tsx",
                                                                    lineNumber: 295,
                                                                    columnNumber: 23
                                                                }, this),
                                                                !isEmpty && /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("path", {
                                                                    fill: "#fbbf24",
                                                                    mask: isFilled ? undefined : `url(#starMask-${index}-${star})`,
                                                                    d: "M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"
                                                                }, void 0, false, {
                                                                    fileName: "[project]/src/components/PartnerCard.tsx",
                                                                    lineNumber: 298,
                                                                    columnNumber: 25
                                                                }, this)
                                                            ]
                                                        }, star, true, {
                                                            fileName: "[project]/src/components/PartnerCard.tsx",
                                                            lineNumber: 287,
                                                            columnNumber: 21
                                                        }, this);
                                                    })
                                                }, void 0, false, {
                                                    fileName: "[project]/src/components/PartnerCard.tsx",
                                                    lineNumber: 278,
                                                    columnNumber: 15
                                                }, this),
                                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                                    className: "flex items-center gap-1",
                                                    children: [
                                                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("span", {
                                                            className: "text-[10px] font-extrabold text-white drop-shadow-[0_2px_6px_rgba(0,0,0,0.95)] sm:text-[12px]",
                                                            children: [
                                                                partner.rating.toFixed(1),
                                                                "/10"
                                                            ]
                                                        }, void 0, true, {
                                                            fileName: "[project]/src/components/PartnerCard.tsx",
                                                            lineNumber: 309,
                                                            columnNumber: 17
                                                        }, this),
                                                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("span", {
                                                            className: "text-[9px] font-bold text-white drop-shadow-[0_2px_4px_rgba(0,0,0,0.9)] sm:text-[11px]",
                                                            children: [
                                                                "(",
                                                                voteCount,
                                                                "+ votes)"
                                                            ]
                                                        }, void 0, true, {
                                                            fileName: "[project]/src/components/PartnerCard.tsx",
                                                            lineNumber: 310,
                                                            columnNumber: 17
                                                        }, this)
                                                    ]
                                                }, void 0, true, {
                                                    fileName: "[project]/src/components/PartnerCard.tsx",
                                                    lineNumber: 308,
                                                    columnNumber: 15
                                                }, this)
                                            ]
                                        }, void 0, true, {
                                            fileName: "[project]/src/components/PartnerCard.tsx",
                                            lineNumber: 276,
                                            columnNumber: 13
                                        }, this)
                                    ]
                                }, void 0, true, {
                                    fileName: "[project]/src/components/PartnerCard.tsx",
                                    lineNumber: 272,
                                    columnNumber: 11
                                }, this)
                            ]
                        }, void 0, true, {
                            fileName: "[project]/src/components/PartnerCard.tsx",
                            lineNumber: 263,
                            columnNumber: 9
                        }, this)
                    }, void 0, false, {
                        fileName: "[project]/src/components/PartnerCard.tsx",
                        lineNumber: 262,
                        columnNumber: 7
                    }, this),
                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                        className: "relative z-20 mt-7 flex items-center gap-2 sm:mt-11 sm:gap-3",
                        children: [
                            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                className: "relative flex-shrink-0",
                                children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                    className: "relative h-20 w-20 overflow-hidden rounded-xl border-2 bg-white p-1 shadow-md sm:shadow-lg transition-all duration-500 group-hover:scale-110 group-hover:shadow-xl sm:h-32 sm:w-32 sm:rounded-3xl sm:p-3",
                                    style: {
                                        borderColor: (0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.buttonBadge, 0.6),
                                        boxShadow: `0 4px 6px -1px ${(0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.buttonBadge, 0.2)}`
                                    },
                                    onMouseEnter: (e)=>{
                                        e.currentTarget.style.borderColor = (0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.buttonBadge, 0.8);
                                        e.currentTarget.style.boxShadow = `0 20px 25px -5px ${(0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.buttonBadge, 0.4)}`;
                                    },
                                    onMouseLeave: (e)=>{
                                        e.currentTarget.style.borderColor = (0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.buttonBadge, 0.6);
                                        e.currentTarget.style.boxShadow = `0 4px 6px -1px ${(0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.buttonBadge, 0.2)}`;
                                    },
                                    children: [
                                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                            className: "absolute -inset-2 rounded-xl sm:opacity-0 blur-md transition-all duration-500 group-hover:opacity-100 sm:rounded-3xl",
                                            style: {
                                                background: `linear-gradient(to right, ${(0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.buttonBadge, 0.15)}, ${(0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.buttonBadge, 0.10)}, ${(0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.buttonBadge, 0.15)})`
                                            }
                                        }, void 0, false, {
                                            fileName: "[project]/src/components/PartnerCard.tsx",
                                            lineNumber: 337,
                                            columnNumber: 13
                                        }, this),
                                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$image$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["default"], {
                                            src: partner.logo,
                                            alt: `${partner.name} logo`,
                                            fill: true,
                                            className: "relative z-10 object-contain brightness-100 contrast-100",
                                            sizes: "(max-width: 640px) 80px, 128px",
                                            priority: index < 2,
                                            loading: index < 2 ? "eager" : "lazy",
                                            quality: 85,
                                            unoptimized: partner.logo.startsWith('/logos/'),
                                            fetchPriority: index < 2 ? "high" : "low"
                                        }, void 0, false, {
                                            fileName: "[project]/src/components/PartnerCard.tsx",
                                            lineNumber: 343,
                                            columnNumber: 13
                                        }, this)
                                    ]
                                }, void 0, true, {
                                    fileName: "[project]/src/components/PartnerCard.tsx",
                                    lineNumber: 321,
                                    columnNumber: 11
                                }, this)
                            }, void 0, false, {
                                fileName: "[project]/src/components/PartnerCard.tsx",
                                lineNumber: 320,
                                columnNumber: 9
                            }, this),
                            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                className: "relative z-10 flex flex-col justify-center",
                                children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                    className: "group/bonus relative inline-block overflow-hidden rounded-lg border backdrop-blur-md px-2.5 py-1.5 shadow-lg sm:px-3 sm:py-2 sm:shadow-xl",
                                    style: {
                                        borderColor: (0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.welcomeBonus, 0.25),
                                        background: `linear-gradient(to bottom right, rgba(0, 0, 0, 0.9), ${(0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.cardBackground, 0.85)}, rgba(0, 0, 0, 0.9))`,
                                        boxShadow: `0 10px 25px -5px rgba(0, 0, 0, 0.5), 0 0 0 1px ${(0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.welcomeBonus, 0.1)}`
                                    },
                                    children: [
                                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                            className: "absolute inset-0 opacity-60",
                                            children: [
                                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                                    className: "absolute top-1 left-1/4 h-0.5 w-0.5 rounded-full animate-pulse",
                                                    style: {
                                                        backgroundColor: (0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.welcomeBonus, 0.8),
                                                        animationDelay: '0s'
                                                    }
                                                }, void 0, false, {
                                                    fileName: "[project]/src/components/PartnerCard.tsx",
                                                    lineNumber: 370,
                                                    columnNumber: 15
                                                }, this),
                                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                                    className: "absolute top-2 right-1/3 h-0.5 w-0.5 rounded-full animate-pulse",
                                                    style: {
                                                        backgroundColor: (0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.welcomeBonus, 0.8),
                                                        animationDelay: '0.5s'
                                                    }
                                                }, void 0, false, {
                                                    fileName: "[project]/src/components/PartnerCard.tsx",
                                                    lineNumber: 377,
                                                    columnNumber: 15
                                                }, this),
                                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                                    className: "absolute bottom-1 left-1/2 h-0.5 w-0.5 rounded-full animate-pulse",
                                                    style: {
                                                        backgroundColor: (0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.welcomeBonus, 0.8),
                                                        animationDelay: '1s'
                                                    }
                                                }, void 0, false, {
                                                    fileName: "[project]/src/components/PartnerCard.tsx",
                                                    lineNumber: 384,
                                                    columnNumber: 15
                                                }, this),
                                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                                    className: "absolute top-1/2 right-1/4 h-0.5 w-0.5 rounded-full animate-pulse",
                                                    style: {
                                                        backgroundColor: (0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.welcomeBonus, 0.8),
                                                        animationDelay: '1.5s'
                                                    }
                                                }, void 0, false, {
                                                    fileName: "[project]/src/components/PartnerCard.tsx",
                                                    lineNumber: 391,
                                                    columnNumber: 15
                                                }, this)
                                            ]
                                        }, void 0, true, {
                                            fileName: "[project]/src/components/PartnerCard.tsx",
                                            lineNumber: 369,
                                            columnNumber: 13
                                        }, this),
                                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                            className: "absolute inset-0 -translate-x-full animate-shimmer",
                                            style: {
                                                background: `linear-gradient(to right, transparent, ${(0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.welcomeBonus, 0.3)}, transparent)`
                                            }
                                        }, void 0, false, {
                                            fileName: "[project]/src/components/PartnerCard.tsx",
                                            lineNumber: 401,
                                            columnNumber: 13
                                        }, this),
                                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                            className: "absolute inset-0 rounded-lg opacity-50 animate-pulse",
                                            style: {
                                                border: `1px solid ${(0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.welcomeBonus, 0.4)}`
                                            }
                                        }, void 0, false, {
                                            fileName: "[project]/src/components/PartnerCard.tsx",
                                            lineNumber: 409,
                                            columnNumber: 13
                                        }, this),
                                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                            className: "relative",
                                            children: [
                                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("p", {
                                                    className: "text-xs font-bold leading-tight mb-1 sm:text-sm sm:mb-1.5 text-left tracking-wide drop-shadow-[0_2px_4px_rgba(0,0,0,0.9)] text-yellow-50",
                                                    children: translations.partners.welcomeBonus
                                                }, void 0, false, {
                                                    fileName: "[project]/src/components/PartnerCard.tsx",
                                                    lineNumber: 418,
                                                    columnNumber: 15
                                                }, this),
                                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("p", {
                                                    className: "text-sm font-extrabold leading-tight text-white drop-shadow-[0_2px_6px_rgba(0,0,0,0.8)] sm:text-lg sm:leading-snug",
                                                    children: partner.welcomeBonus
                                                }, void 0, false, {
                                                    fileName: "[project]/src/components/PartnerCard.tsx",
                                                    lineNumber: 421,
                                                    columnNumber: 15
                                                }, this)
                                            ]
                                        }, void 0, true, {
                                            fileName: "[project]/src/components/PartnerCard.tsx",
                                            lineNumber: 417,
                                            columnNumber: 13
                                        }, this)
                                    ]
                                }, void 0, true, {
                                    fileName: "[project]/src/components/PartnerCard.tsx",
                                    lineNumber: 360,
                                    columnNumber: 11
                                }, this)
                            }, void 0, false, {
                                fileName: "[project]/src/components/PartnerCard.tsx",
                                lineNumber: 359,
                                columnNumber: 9
                            }, this)
                        ]
                    }, void 0, true, {
                        fileName: "[project]/src/components/PartnerCard.tsx",
                        lineNumber: 318,
                        columnNumber: 7
                    }, this),
                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                        className: "relative z-20 mt-3 space-y-0.5 sm:mt-4 sm:space-y-1.5",
                        children: [
                            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("a", {
                                href: affiliateHref,
                                target: "_blank",
                                rel: "nofollow sponsored noopener",
                                onClick: handleClick,
                                className: "group/btn relative flex w-full items-center justify-center gap-2 overflow-hidden rounded-xl px-4 py-3 text-sm font-extrabold text-white transition-all duration-300 hover:scale-[1.05] active:scale-[0.96] focus-visible:outline focus-visible:outline-3 focus-visible:outline-offset-2 sm:rounded-2xl sm:px-6 sm:py-4 sm:text-lg sm:gap-2.5",
                                onFocus: (e)=>{
                                    e.currentTarget.style.outlineColor = colorTheme.buttonBadge;
                                },
                                onBlur: (e)=>{
                                    e.currentTarget.style.outlineColor = '';
                                },
                                style: {
                                    background: `linear-gradient(to right, ${colorTheme.buttonBadge}, ${colorTheme.buttonBadge})`,
                                    boxShadow: `0 4px 20px ${(0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.buttonBadge, 0.4)}, 0 2px 8px ${(0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.cardBackground, 0.3)}`
                                },
                                onMouseEnter: (e)=>{
                                    // Lighten the buttonBadge color on hover
                                    const lighten = (hex, percent)=>{
                                        const num = parseInt(hex.replace("#", ""), 16);
                                        const r = Math.min(255, (num >> 16) + Math.round(255 * percent));
                                        const g = Math.min(255, (num >> 8 & 0x00FF) + Math.round(255 * percent));
                                        const b = Math.min(255, (num & 0x0000FF) + Math.round(255 * percent));
                                        return `#${(r << 16 | g << 8 | b).toString(16).padStart(6, '0')}`;
                                    };
                                    const lighter = lighten(colorTheme.buttonBadge, 0.1);
                                    e.currentTarget.style.background = `linear-gradient(to right, ${lighter}, ${colorTheme.buttonBadge})`;
                                    e.currentTarget.style.boxShadow = `0 8px 32px ${(0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.buttonBadge, 0.6)}, 0 4px 16px ${(0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.cardBackground, 0.4)}`;
                                },
                                onMouseLeave: (e)=>{
                                    e.currentTarget.style.background = `linear-gradient(to right, ${colorTheme.buttonBadge}, ${colorTheme.buttonBadge})`;
                                    e.currentTarget.style.boxShadow = `0 4px 20px ${(0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.buttonBadge, 0.4)}, 0 2px 8px ${(0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.cardBackground, 0.3)}`;
                                },
                                children: [
                                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("span", {
                                        className: "absolute -inset-1 rounded-xl blur-xl opacity-60 transition-all duration-300 group-hover/btn:opacity-80 group-hover/btn:blur-2xl group-active/btn:opacity-40 sm:rounded-2xl",
                                        style: {
                                            background: `linear-gradient(to right, ${(0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.buttonBadge, 0.5)}, ${(0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.buttonBadge, 0.5)}, ${(0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.buttonBadge, 0.5)})`
                                        }
                                    }, void 0, false, {
                                        fileName: "[project]/src/components/PartnerCard.tsx",
                                        lineNumber: 466,
                                        columnNumber: 11
                                    }, this),
                                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("span", {
                                        className: "absolute inset-0 rounded-xl opacity-50 transition-opacity duration-300 group-hover/btn:opacity-70 sm:rounded-2xl",
                                        style: {
                                            background: `linear-gradient(to bottom right, ${(0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.buttonBadge, 0.2)}, transparent, transparent)`
                                        }
                                    }, void 0, false, {
                                        fileName: "[project]/src/components/PartnerCard.tsx",
                                        lineNumber: 474,
                                        columnNumber: 11
                                    }, this),
                                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("span", {
                                        className: "absolute inset-0 -translate-x-full transition-transform duration-1000 group-hover/btn:translate-x-full sm:rounded-2xl",
                                        style: {
                                            background: `linear-gradient(to right, transparent, ${(0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.buttonBadge, 0.4)}, transparent)`
                                        }
                                    }, void 0, false, {
                                        fileName: "[project]/src/components/PartnerCard.tsx",
                                        lineNumber: 482,
                                        columnNumber: 11
                                    }, this),
                                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("span", {
                                        className: "absolute top-2 left-4 h-1.5 w-1.5 rounded-full animate-pulse",
                                        style: {
                                            backgroundColor: (0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.buttonBadge, 0.9),
                                            boxShadow: `0 0 8px ${colorTheme.buttonBadge}`,
                                            animationDelay: '0s'
                                        }
                                    }, void 0, false, {
                                        fileName: "[project]/src/components/PartnerCard.tsx",
                                        lineNumber: 490,
                                        columnNumber: 11
                                    }, this),
                                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("span", {
                                        className: "absolute top-2 right-4 h-1.5 w-1.5 rounded-full animate-pulse",
                                        style: {
                                            backgroundColor: (0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.buttonBadge, 0.9),
                                            boxShadow: `0 0 8px ${colorTheme.buttonBadge}`,
                                            animationDelay: '0.3s'
                                        }
                                    }, void 0, false, {
                                        fileName: "[project]/src/components/PartnerCard.tsx",
                                        lineNumber: 498,
                                        columnNumber: 11
                                    }, this),
                                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("span", {
                                        className: "absolute bottom-2 left-1/3 h-1 w-1 rounded-full animate-pulse",
                                        style: {
                                            backgroundColor: (0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.buttonBadge, 0.8),
                                            boxShadow: `0 0 6px ${colorTheme.buttonBadge}`,
                                            animationDelay: '0.6s'
                                        }
                                    }, void 0, false, {
                                        fileName: "[project]/src/components/PartnerCard.tsx",
                                        lineNumber: 506,
                                        columnNumber: 11
                                    }, this),
                                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("span", {
                                        className: "absolute bottom-2 right-1/4 h-1 w-1 rounded-full animate-pulse",
                                        style: {
                                            backgroundColor: (0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.buttonBadge, 0.8),
                                            boxShadow: `0 0 6px ${colorTheme.buttonBadge}`,
                                            animationDelay: '0.9s'
                                        }
                                    }, void 0, false, {
                                        fileName: "[project]/src/components/PartnerCard.tsx",
                                        lineNumber: 514,
                                        columnNumber: 11
                                    }, this),
                                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("span", {
                                        className: "relative z-10 flex items-center gap-1.5 sm:gap-2",
                                        children: [
                                            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("span", {
                                                className: "text-sm font-black text-white drop-shadow-[0_3px_10px_rgba(0,0,0,0.9)] sm:text-lg",
                                                children: translations.partners.claimNow
                                            }, void 0, false, {
                                                fileName: "[project]/src/components/PartnerCard.tsx",
                                                lineNumber: 525,
                                                columnNumber: 13
                                            }, this),
                                            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("svg", {
                                                className: "h-3.5 w-3.5 transition-all duration-300 group-hover/btn:translate-x-2 group-hover/btn:scale-110 sm:h-5 sm:w-5",
                                                fill: "none",
                                                viewBox: "0 0 24 24",
                                                stroke: "currentColor",
                                                strokeWidth: 3,
                                                children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("path", {
                                                    strokeLinecap: "round",
                                                    strokeLinejoin: "round",
                                                    d: "M13 7l5 5m0 0l-5 5m5-5H6"
                                                }, void 0, false, {
                                                    fileName: "[project]/src/components/PartnerCard.tsx",
                                                    lineNumber: 533,
                                                    columnNumber: 15
                                                }, this)
                                            }, void 0, false, {
                                                fileName: "[project]/src/components/PartnerCard.tsx",
                                                lineNumber: 526,
                                                columnNumber: 13
                                            }, this)
                                        ]
                                    }, void 0, true, {
                                        fileName: "[project]/src/components/PartnerCard.tsx",
                                        lineNumber: 524,
                                        columnNumber: 11
                                    }, this)
                                ]
                            }, void 0, true, {
                                fileName: "[project]/src/components/PartnerCard.tsx",
                                lineNumber: 431,
                                columnNumber: 9
                            }, this),
                            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("p", {
                                className: "text-center text-[8px] font-medium leading-tight text-slate-300 sm:text-xs sm:leading-relaxed",
                                children: translations.partners.terms
                            }, void 0, false, {
                                fileName: "[project]/src/components/PartnerCard.tsx",
                                lineNumber: 537,
                                columnNumber: 9
                            }, this)
                        ]
                    }, void 0, true, {
                        fileName: "[project]/src/components/PartnerCard.tsx",
                        lineNumber: 430,
                        columnNumber: 7
                    }, this)
                ]
            }, void 0, true, {
                fileName: "[project]/src/components/PartnerCard.tsx",
                lineNumber: 170,
                columnNumber: 7
            }, this)
        ]
    }, void 0, true, {
        fileName: "[project]/src/components/PartnerCard.tsx",
        lineNumber: 129,
        columnNumber: 5
    }, this);
}
_s(PartnerCard, "LTT/ETak1fktnlvHs1X+nr9uoeg=");
_c = PartnerCard;
var _c;
__turbopack_context__.k.register(_c, "PartnerCard");
if (typeof globalThis.$RefreshHelpers$ === 'object' && globalThis.$RefreshHelpers !== null) {
    __turbopack_context__.k.registerExports(__turbopack_context__.m, globalThis.$RefreshHelpers$);
}
}),
"[project]/src/components/PartnerShowcase.tsx [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "PartnerShowcase",
    ()=>PartnerShowcase
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/next/dist/compiled/react/jsx-dev-runtime.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/next/dist/compiled/react/index.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$components$2f$PartnerCard$2e$tsx__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/src/components/PartnerCard.tsx [app-client] (ecmascript)");
;
var _s = __turbopack_context__.k.signature();
"use client";
;
;
function PartnerShowcase({ partners, licensedPartners, initialShowAll, gclid, accountCode, partnersToShow, translations, language, theme }) {
    _s();
    // Memoize client-side check to avoid re-evaluation
    const hasNavigatorUserAgent = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useMemo"])({
        "PartnerShowcase.useMemo[hasNavigatorUserAgent]": ()=>typeof navigator === "undefined" ? true : Boolean(navigator.userAgent)
    }["PartnerShowcase.useMemo[hasNavigatorUserAgent]"], []);
    const showAll = initialShowAll && hasNavigatorUserAgent;
    // Memoize partner cards with affiliate links
    // gclid is used ONLY for affiliate tracking, never exposed in HTML attributes or metadata
    const partnerCards = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useMemo"])({
        "PartnerShowcase.useMemo[partnerCards]": ()=>{
            const gclidValue = gclid ?? "organic";
            // If partnersToShow is provided, use it (server-side filtered)
            // Otherwise, use the existing logic (showAll ? partners : licensedPartners)
            const list = partnersToShow ?? (showAll ? partners : licensedPartners);
            return list.map({
                "PartnerShowcase.useMemo[partnerCards]": (partner)=>{
                    const linkWithAccount = partner.affiliateLink.replace("{AccountCode}", accountCode);
                    // gclid is only appended to affiliate links (external), never to internal URLs
                    const affiliateHref = `${linkWithAccount}${encodeURIComponent(gclidValue)}`;
                    return {
                        partner,
                        affiliateHref
                    };
                }
            }["PartnerShowcase.useMemo[partnerCards]"]);
        }
    }["PartnerShowcase.useMemo[partnerCards]"], [
        accountCode,
        gclid,
        licensedPartners,
        partners,
        partnersToShow,
        showAll
    ]);
    return /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("section", {
        "aria-labelledby": "partners-heading",
        className: "space-y-2 sm:space-y-6",
        children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
            className: "grid gap-2.5 sm:gap-6 md:grid-cols-2 lg:gap-8",
            children: partnerCards.map(({ partner, affiliateHref }, index)=>/*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$src$2f$components$2f$PartnerCard$2e$tsx__$5b$app$2d$client$5d$__$28$ecmascript$29$__["PartnerCard"], {
                    partner: partner,
                    affiliateHref: affiliateHref,
                    index: index,
                    translations: translations,
                    language: language,
                    theme: theme
                }, partner.name, false, {
                    fileName: "[project]/src/components/PartnerShowcase.tsx",
                    lineNumber: 62,
                    columnNumber: 11
                }, this))
        }, void 0, false, {
            fileName: "[project]/src/components/PartnerShowcase.tsx",
            lineNumber: 60,
            columnNumber: 7
        }, this)
    }, void 0, false, {
        fileName: "[project]/src/components/PartnerShowcase.tsx",
        lineNumber: 59,
        columnNumber: 5
    }, this);
}
_s(PartnerShowcase, "3cJ7khwoZe2p0NNlSXEV+lItKFs=");
_c = PartnerShowcase;
var _c;
__turbopack_context__.k.register(_c, "PartnerShowcase");
if (typeof globalThis.$RefreshHelpers$ === 'object' && globalThis.$RefreshHelpers !== null) {
    __turbopack_context__.k.registerExports(__turbopack_context__.m, globalThis.$RefreshHelpers$);
}
}),
"[project]/src/components/VisibilityDebug.tsx [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "VisibilityDebug",
    ()=>VisibilityDebug
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$build$2f$polyfills$2f$process$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = /*#__PURE__*/ __turbopack_context__.i("[project]/node_modules/next/dist/build/polyfills/process.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/next/dist/compiled/react/jsx-dev-runtime.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/next/dist/compiled/react/index.js [app-client] (ecmascript)");
;
var _s = __turbopack_context__.k.signature();
"use client";
;
function VisibilityDebug({ showAll, showUnlicensed }) {
    _s();
    const [isDismissed, setIsDismissed] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useState"])(false);
    const [isMounted, setIsMounted] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useState"])(false);
    const [isDevelopment, setIsDevelopment] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useState"])(false);
    // Only check environment on client-side after mount to prevent hydration mismatch
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useEffect"])({
        "VisibilityDebug.useEffect": ()=>{
            setIsMounted(true);
            setIsDevelopment(("TURBOPACK compile-time value", "development") === "development");
        }
    }["VisibilityDebug.useEffect"], []);
    // Don't render until mounted to prevent hydration mismatch
    if (!isMounted || !isDevelopment || isDismissed) return null;
    const displayText = showUnlicensed ? "Show ONLY Unlicensed" : "Show ONLY Licensed";
    const displayColor = showUnlicensed ? "text-red-600" : "text-green-600";
    return /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
        className: "fixed bottom-4 right-4 z-50 max-w-sm rounded-lg border-2 border-blue-500 bg-white p-4 shadow-xl",
        children: [
            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                className: "mb-2 flex items-center justify-between",
                children: [
                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("h3", {
                        className: "text-sm font-bold text-slate-900",
                        children: "🔍 Visibility Debug"
                    }, void 0, false, {
                        fileName: "[project]/src/components/VisibilityDebug.tsx",
                        lineNumber: 38,
                        columnNumber: 9
                    }, this),
                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("button", {
                        onClick: ()=>setIsDismissed(true),
                        className: "text-slate-400 hover:text-slate-600",
                        "aria-label": "Close",
                        children: "×"
                    }, void 0, false, {
                        fileName: "[project]/src/components/VisibilityDebug.tsx",
                        lineNumber: 39,
                        columnNumber: 9
                    }, this)
                ]
            }, void 0, true, {
                fileName: "[project]/src/components/VisibilityDebug.tsx",
                lineNumber: 37,
                columnNumber: 7
            }, this),
            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                className: "space-y-2 text-xs",
                children: [
                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                        className: "mt-3 border-t border-slate-200 pt-2",
                        children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                            className: "flex items-center justify-between",
                            children: [
                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("span", {
                                    className: "font-bold text-slate-900",
                                    children: "Visibility Result:"
                                }, void 0, false, {
                                    fileName: "[project]/src/components/VisibilityDebug.tsx",
                                    lineNumber: 50,
                                    columnNumber: 13
                                }, this),
                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("span", {
                                    className: `font-bold ${displayColor}`,
                                    children: displayText
                                }, void 0, false, {
                                    fileName: "[project]/src/components/VisibilityDebug.tsx",
                                    lineNumber: 51,
                                    columnNumber: 13
                                }, this)
                            ]
                        }, void 0, true, {
                            fileName: "[project]/src/components/VisibilityDebug.tsx",
                            lineNumber: 49,
                            columnNumber: 11
                        }, this)
                    }, void 0, false, {
                        fileName: "[project]/src/components/VisibilityDebug.tsx",
                        lineNumber: 48,
                        columnNumber: 9
                    }, this),
                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("p", {
                        className: "text-xs text-slate-500 italic",
                        children: "Sensitive detection data is never exposed in HTML"
                    }, void 0, false, {
                        fileName: "[project]/src/components/VisibilityDebug.tsx",
                        lineNumber: 56,
                        columnNumber: 9
                    }, this)
                ]
            }, void 0, true, {
                fileName: "[project]/src/components/VisibilityDebug.tsx",
                lineNumber: 47,
                columnNumber: 7
            }, this)
        ]
    }, void 0, true, {
        fileName: "[project]/src/components/VisibilityDebug.tsx",
        lineNumber: 36,
        columnNumber: 5
    }, this);
}
_s(VisibilityDebug, "JcFVirHqqqSfP0YI4853VwMiPcY=");
_c = VisibilityDebug;
var _c;
__turbopack_context__.k.register(_c, "VisibilityDebug");
if (typeof globalThis.$RefreshHelpers$ === 'object' && globalThis.$RefreshHelpers !== null) {
    __turbopack_context__.k.registerExports(__turbopack_context__.m, globalThis.$RefreshHelpers$);
}
}),
"[project]/src/components/VisitorTracker.tsx [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "VisitorTracker",
    ()=>VisitorTracker
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/next/dist/compiled/react/index.js [app-client] (ecmascript)");
var _s = __turbopack_context__.k.signature();
"use client";
;
function VisitorTracker() {
    _s();
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useEffect"])({
        "VisitorTracker.useEffect": ()=>{
            // Only track on client side
            if ("TURBOPACK compile-time falsy", 0) //TURBOPACK unreachable
            ;
            // Get the full URL including query parameters
            const entryUrl = window.location.href;
            const userAgent = navigator.userAgent;
            const referer = document.referrer || null;
            // Track visitor asynchronously without blocking page load
            fetch("/api/visitors", {
                method: "POST",
                headers: {
                    "Content-Type": "application/json"
                },
                body: JSON.stringify({
                    url: entryUrl,
                    userAgent: userAgent,
                    referer: referer
                })
            }).catch({
                "VisitorTracker.useEffect": (error)=>{
                    // Silently fail - don't block user experience
                    console.error("Failed to track visitor:", error);
                }
            }["VisitorTracker.useEffect"]);
        }
    }["VisitorTracker.useEffect"], []);
    return null; // This component doesn't render anything
}
_s(VisitorTracker, "OD7bBpZva5O2jO+Puf00hKivP7c=");
_c = VisitorTracker;
var _c;
__turbopack_context__.k.register(_c, "VisitorTracker");
if (typeof globalThis.$RefreshHelpers$ === 'object' && globalThis.$RefreshHelpers !== null) {
    __turbopack_context__.k.registerExports(__turbopack_context__.m, globalThis.$RefreshHelpers$);
}
}),
"[project]/src/components/FAQSection.tsx [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "FAQSection",
    ()=>FAQSection
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/next/dist/compiled/react/jsx-dev-runtime.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/next/dist/compiled/react/index.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/src/lib/color-theme.ts [app-client] (ecmascript)");
;
var _s = __turbopack_context__.k.signature();
"use client";
;
;
function FAQSection({ translations, language, theme }) {
    _s();
    const [openIndex, setOpenIndex] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useState"])(null);
    const colorTheme = (0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["getColorTheme"])(theme);
    const toggleQuestion = (index)=>{
        setOpenIndex(openIndex === index ? null : index);
    };
    return /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("section", {
        className: "relative space-y-5 overflow-hidden rounded-2xl border p-5 shadow-xl backdrop-blur-sm sm:space-y-6 sm:rounded-3xl sm:p-8",
        style: {
            borderColor: (0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.buttonBadge, 0.2),
            background: `linear-gradient(to bottom right, rgba(0, 0, 0, 0.98), ${(0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.cardBackground, 0.95)}, rgba(0, 0, 0, 0.98))`,
            boxShadow: `0 20px 50px -10px rgba(0, 0, 0, 0.8), 0 0 0 1px ${(0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.buttonBadge, 0.1)}`
        },
        children: [
            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                className: "absolute inset-0",
                style: {
                    background: `radial-gradient(circle at 30% 20%, ${(0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.buttonBadge, 0.06)}, transparent 60%)`
                }
            }, void 0, false, {
                fileName: "[project]/src/components/FAQSection.tsx",
                lineNumber: 33,
                columnNumber: 7
            }, this),
            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                className: "absolute inset-0",
                style: {
                    background: `radial-gradient(circle at 70% 80%, ${(0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.welcomeBonus, 0.04)}, transparent 60%)`
                }
            }, void 0, false, {
                fileName: "[project]/src/components/FAQSection.tsx",
                lineNumber: 39,
                columnNumber: 7
            }, this),
            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                className: "relative space-y-2 text-center sm:space-y-3",
                children: [
                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                        className: "inline-flex items-center gap-2 rounded-full px-3 py-1 backdrop-blur-sm sm:px-4 sm:py-1.5",
                        style: {
                            border: `1px solid ${(0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.buttonBadge, 0.2)}`,
                            backgroundColor: (0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.buttonBadge, 0.05)
                        },
                        children: [
                            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("svg", {
                                className: "h-3 w-3 sm:h-4 sm:w-4",
                                fill: "none",
                                viewBox: "0 0 24 24",
                                stroke: "currentColor",
                                strokeWidth: 2.5,
                                style: {
                                    color: colorTheme.buttonBadge
                                },
                                children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("path", {
                                    strokeLinecap: "round",
                                    strokeLinejoin: "round",
                                    d: "M8.228 9c.549-1.165 2.03-2 3.772-2 2.21 0 4 1.343 4 3 0 1.4-1.278 2.575-3.006 2.907-.542.104-.994.54-.994 1.093m0 3h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"
                                }, void 0, false, {
                                    fileName: "[project]/src/components/FAQSection.tsx",
                                    lineNumber: 63,
                                    columnNumber: 13
                                }, this)
                            }, void 0, false, {
                                fileName: "[project]/src/components/FAQSection.tsx",
                                lineNumber: 55,
                                columnNumber: 11
                            }, this),
                            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("span", {
                                className: "text-[10px] font-semibold uppercase tracking-wider sm:text-xs",
                                style: {
                                    color: (0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.buttonBadge, 0.9)
                                },
                                children: translations.faq.badge
                            }, void 0, false, {
                                fileName: "[project]/src/components/FAQSection.tsx",
                                lineNumber: 65,
                                columnNumber: 11
                            }, this)
                        ]
                    }, void 0, true, {
                        fileName: "[project]/src/components/FAQSection.tsx",
                        lineNumber: 48,
                        columnNumber: 9
                    }, this),
                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("h2", {
                        className: "text-2xl font-bold tracking-tight text-white sm:text-3xl lg:text-4xl",
                        children: translations.faq.title
                    }, void 0, false, {
                        fileName: "[project]/src/components/FAQSection.tsx",
                        lineNumber: 72,
                        columnNumber: 9
                    }, this),
                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("p", {
                        className: "mx-auto max-w-2xl text-sm leading-relaxed text-slate-300/90 sm:text-base sm:text-white/80",
                        children: translations.faq.subtitle
                    }, void 0, false, {
                        fileName: "[project]/src/components/FAQSection.tsx",
                        lineNumber: 75,
                        columnNumber: 9
                    }, this)
                ]
            }, void 0, true, {
                fileName: "[project]/src/components/FAQSection.tsx",
                lineNumber: 47,
                columnNumber: 7
            }, this),
            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                className: "relative space-y-2.5 sm:space-y-3",
                children: translations.faq.items.map((item, index)=>{
                    const isOpen = openIndex === index;
                    return /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                        className: "group overflow-hidden rounded-xl border transition-all duration-300",
                        style: {
                            borderColor: (0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.buttonBadge, 0.25),
                            background: `linear-gradient(to bottom right, rgba(0, 0, 0, 0.9), ${(0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.cardBackground, 0.85)}, rgba(0, 0, 0, 0.9))`,
                            boxShadow: `0 10px 25px -5px rgba(0, 0, 0, 0.5), 0 0 0 1px ${(0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.buttonBadge, 0.1)}`
                        },
                        onMouseEnter: (e)=>{
                            e.currentTarget.style.borderColor = (0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.buttonBadge, 0.35);
                            e.currentTarget.style.boxShadow = `0 10px 25px -5px rgba(0, 0, 0, 0.6), 0 0 0 1px ${(0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.buttonBadge, 0.15)}`;
                        },
                        onMouseLeave: (e)=>{
                            e.currentTarget.style.borderColor = (0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.buttonBadge, 0.25);
                            e.currentTarget.style.boxShadow = `0 10px 25px -5px rgba(0, 0, 0, 0.5), 0 0 0 1px ${(0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.buttonBadge, 0.1)}`;
                        },
                        children: [
                            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("button", {
                                type: "button",
                                onClick: ()=>toggleQuestion(index),
                                className: "flex w-full items-center justify-between gap-4 p-3 text-left transition-colors hover:bg-slate-800/50 sm:p-4",
                                "aria-expanded": isOpen,
                                children: [
                                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("h3", {
                                        className: "flex-1 text-sm font-semibold leading-tight text-white sm:text-base",
                                        children: item.question
                                    }, void 0, false, {
                                        fileName: "[project]/src/components/FAQSection.tsx",
                                        lineNumber: 108,
                                        columnNumber: 17
                                    }, this),
                                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("svg", {
                                        className: `h-5 w-5 flex-shrink-0 transition-transform duration-300 ${isOpen ? "rotate-180" : ""}`,
                                        fill: "none",
                                        viewBox: "0 0 24 24",
                                        stroke: "currentColor",
                                        strokeWidth: 2.5,
                                        style: {
                                            color: colorTheme.buttonBadge
                                        },
                                        children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("path", {
                                            strokeLinecap: "round",
                                            strokeLinejoin: "round",
                                            d: "M19 9l-7 7-7-7"
                                        }, void 0, false, {
                                            fileName: "[project]/src/components/FAQSection.tsx",
                                            lineNumber: 121,
                                            columnNumber: 19
                                        }, this)
                                    }, void 0, false, {
                                        fileName: "[project]/src/components/FAQSection.tsx",
                                        lineNumber: 111,
                                        columnNumber: 17
                                    }, this)
                                ]
                            }, void 0, true, {
                                fileName: "[project]/src/components/FAQSection.tsx",
                                lineNumber: 102,
                                columnNumber: 15
                            }, this),
                            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                className: `overflow-hidden transition-all duration-300 ${isOpen ? "max-h-[500px] opacity-100" : "max-h-0 opacity-0"}`,
                                children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                    className: "border-t p-3 sm:p-4",
                                    style: {
                                        borderColor: (0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.buttonBadge, 0.5),
                                        backgroundColor: (0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.cardBackground, 0.3)
                                    },
                                    children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("p", {
                                        className: "text-xs leading-relaxed text-slate-300/90 sm:text-sm sm:text-white/70",
                                        children: item.answer
                                    }, void 0, false, {
                                        fileName: "[project]/src/components/FAQSection.tsx",
                                        lineNumber: 136,
                                        columnNumber: 19
                                    }, this)
                                }, void 0, false, {
                                    fileName: "[project]/src/components/FAQSection.tsx",
                                    lineNumber: 129,
                                    columnNumber: 17
                                }, this)
                            }, void 0, false, {
                                fileName: "[project]/src/components/FAQSection.tsx",
                                lineNumber: 124,
                                columnNumber: 15
                            }, this)
                        ]
                    }, index, true, {
                        fileName: "[project]/src/components/FAQSection.tsx",
                        lineNumber: 85,
                        columnNumber: 13
                    }, this);
                })
            }, void 0, false, {
                fileName: "[project]/src/components/FAQSection.tsx",
                lineNumber: 81,
                columnNumber: 7
            }, this)
        ]
    }, void 0, true, {
        fileName: "[project]/src/components/FAQSection.tsx",
        lineNumber: 24,
        columnNumber: 5
    }, this);
}
_s(FAQSection, "7z1SfW1ag/kVV/D8SOtFgmPOJ8o=");
_c = FAQSection;
var _c;
__turbopack_context__.k.register(_c, "FAQSection");
if (typeof globalThis.$RefreshHelpers$ === 'object' && globalThis.$RefreshHelpers !== null) {
    __turbopack_context__.k.registerExports(__turbopack_context__.m, globalThis.$RefreshHelpers$);
}
}),
"[project]/node_modules/next/dist/shared/lib/lazy-dynamic/dynamic-bailout-to-csr.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "BailoutToCSR", {
    enumerable: true,
    get: function() {
        return BailoutToCSR;
    }
});
const _bailouttocsr = __turbopack_context__.r("[project]/node_modules/next/dist/shared/lib/lazy-dynamic/bailout-to-csr.js [app-client] (ecmascript)");
function BailoutToCSR({ reason, children }) {
    if (typeof window === 'undefined') {
        throw Object.defineProperty(new _bailouttocsr.BailoutToCSRError(reason), "__NEXT_ERROR_CODE", {
            value: "E394",
            enumerable: false,
            configurable: true
        });
    }
    return children;
} //# sourceMappingURL=dynamic-bailout-to-csr.js.map
}),
"[project]/node_modules/next/dist/shared/lib/encode-uri-path.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "encodeURIPath", {
    enumerable: true,
    get: function() {
        return encodeURIPath;
    }
});
function encodeURIPath(file) {
    return file.split('/').map((p)=>encodeURIComponent(p)).join('/');
} //# sourceMappingURL=encode-uri-path.js.map
}),
"[project]/node_modules/next/dist/shared/lib/lazy-dynamic/preload-chunks.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$build$2f$polyfills$2f$process$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = /*#__PURE__*/ __turbopack_context__.i("[project]/node_modules/next/dist/build/polyfills/process.js [app-client] (ecmascript)");
'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "PreloadChunks", {
    enumerable: true,
    get: function() {
        return PreloadChunks;
    }
});
const _jsxruntime = __turbopack_context__.r("[project]/node_modules/next/dist/compiled/react/jsx-runtime.js [app-client] (ecmascript)");
const _reactdom = __turbopack_context__.r("[project]/node_modules/next/dist/compiled/react-dom/index.js [app-client] (ecmascript)");
const _workasyncstorageexternal = __turbopack_context__.r("[project]/node_modules/next/dist/server/app-render/work-async-storage.external.js [app-client] (ecmascript)");
const _encodeuripath = __turbopack_context__.r("[project]/node_modules/next/dist/shared/lib/encode-uri-path.js [app-client] (ecmascript)");
function PreloadChunks({ moduleIds }) {
    // Early return in client compilation and only load requestStore on server side
    if (typeof window !== 'undefined') {
        return null;
    }
    const workStore = _workasyncstorageexternal.workAsyncStorage.getStore();
    if (workStore === undefined) {
        return null;
    }
    const allFiles = [];
    // Search the current dynamic call unique key id in react loadable manifest,
    // and find the corresponding CSS files to preload
    if (workStore.reactLoadableManifest && moduleIds) {
        const manifest = workStore.reactLoadableManifest;
        for (const key of moduleIds){
            if (!manifest[key]) continue;
            const chunks = manifest[key].files;
            allFiles.push(...chunks);
        }
    }
    if (allFiles.length === 0) {
        return null;
    }
    const dplId = ("TURBOPACK compile-time falsy", 0) ? "TURBOPACK unreachable" : '';
    return /*#__PURE__*/ (0, _jsxruntime.jsx)(_jsxruntime.Fragment, {
        children: allFiles.map((chunk)=>{
            const href = `${workStore.assetPrefix}/_next/${(0, _encodeuripath.encodeURIPath)(chunk)}${dplId}`;
            const isCss = chunk.endsWith('.css');
            // If it's stylesheet we use `precedence` o help hoist with React Float.
            // For stylesheets we actually need to render the CSS because nothing else is going to do it so it needs to be part of the component tree.
            // The `preload` for stylesheet is not optional.
            if (isCss) {
                return /*#__PURE__*/ (0, _jsxruntime.jsx)("link", {
                    // @ts-ignore
                    precedence: "dynamic",
                    href: href,
                    rel: "stylesheet",
                    as: "style",
                    nonce: workStore.nonce
                }, chunk);
            } else {
                // If it's script we use ReactDOM.preload to preload the resources
                (0, _reactdom.preload)(href, {
                    as: 'script',
                    fetchPriority: 'low',
                    nonce: workStore.nonce
                });
                return null;
            }
        })
    });
} //# sourceMappingURL=preload-chunks.js.map
}),
]);

//# sourceMappingURL=_e22cb0b9._.js.map