import type { LanguageCode } from "@/types/language";
import type { ThemeId } from "@/types/theme";
import type { SiteInfo } from "@/types/data";
import { FooterEN } from "./FooterEN";
import { FooterPT } from "./FooterPT";
import { FooterDK } from "./FooterDK";

interface FooterProps {
  readonly siteInfo: SiteInfo;
  readonly language: LanguageCode;
  readonly theme: ThemeId;
}

/**
 * Language-specific footer component
 * Renders different footer markup per language (not just translated text)
 * Each language has its own compliance structure and images
 */
export function Footer({ siteInfo, language, theme }: FooterProps) {
  switch (language) {
    case "en":
      return <FooterEN siteInfo={siteInfo} language={language} theme={theme} />;
    case "pt":
      return <FooterPT siteInfo={siteInfo} language={language} theme={theme} />;
    case "dk":
      return <FooterDK siteInfo={siteInfo} language={language} theme={theme} />;
    case "fr":
      return <FooterEN siteInfo={siteInfo} language={language} theme={theme} />;
    case "nl":
      return <FooterEN siteInfo={siteInfo} language={language} theme={theme} />;
    case "sv":
      return <FooterEN siteInfo={siteInfo} language={language} theme={theme} />;
    case "es":
      return <FooterEN siteInfo={siteInfo} language={language} theme={theme} />;
    default:
      return <FooterPT siteInfo={siteInfo} language={language} theme={theme} />;
  }
}

