# Fix for 503 Service Unavailable Error

## Problem
The error `Cannot find module './format-serie3'` indicates a **corrupted Next.js installation** in your virtual environment. This causes the server to fail to start, resulting in a 503 error.

## Root Cause
The Next.js package in your nodevenv is corrupted or incomplete:
- Location: `/home/betruixl/nodevenv/trustrank.live/22/lib/node_modules/next/`
- The internal Next.js module `format-serie3` is missing or corrupted

## Solution

### Option 1: Quick Fix (Recommended)

SSH into your server and run:

```bash
cd /home/betruixl/trustrank.live

# Remove corrupted build
rm -rf .next

# Reinstall Next.js
npm uninstall next
npm install next@16.0.3 --save

# Rebuild
npm run build

# Restart your server
```

### Option 2: Complete Clean Reinstall

If Option 1 doesn't work:

```bash
cd /home/betruixl/trustrank.live

# Remove all build artifacts
rm -rf .next
rm -rf node_modules/.cache

# Remove and reinstall Next.js
npm uninstall next
npm install next@16.0.3 --save

# If still having issues, reinstall all dependencies
npm install

# Rebuild
npm run build

# Restart server
```

### Option 3: Using the Fix Script

1. Upload `fix-hosting-issue.sh` to your server
2. Make it executable:
   ```bash
   chmod +x fix-hosting-issue.sh
   ```
3. Run it:
   ```bash
   ./fix-hosting-issue.sh
   ```

## After Fixing

1. **Restart your server** using your hosting control panel or:
   - `pm2 restart all`
   - `systemctl restart your-service`
   - Or your hosting's restart command

2. **Verify the fix** by checking:
   - Server logs show "Next.js app prepared successfully"
   - No more "Cannot find module" errors
   - Website loads without 503 error

## Prevention

To prevent this in the future:

1. **Always ensure builds complete successfully** - Don't interrupt build processes
2. **Keep Next.js version consistent** - Don't mix versions between environments
3. **Regular maintenance** - Periodically clean build artifacts:
   ```bash
   rm -rf .next
   npm run build
   ```

## If Problem Persists

If the error continues after trying all options:

1. **Check Node.js version compatibility**:
   ```bash
   node --version  # Should be compatible with Next.js 16.0.3
   ```

2. **Verify package.json** matches your local version

3. **Check virtual environment** is properly activated

4. **Contact hosting support** if the issue is with the nodevenv setup

## Additional Notes

- The error occurs because Next.js internal files are corrupted
- This is NOT a code issue - it's an installation/build issue
- The fix requires reinstalling Next.js and rebuilding
- Make sure you have write permissions in the project directory

