(globalThis.TURBOPACK || (globalThis.TURBOPACK = [])).push([typeof document === "object" ? document.currentScript : undefined,
"[project]/src/types/theme.ts [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "DEFAULT_THEME",
    ()=>DEFAULT_THEME,
    "SUPPORTED_THEMES",
    ()=>SUPPORTED_THEMES,
    "THEME_NAMES",
    ()=>THEME_NAMES,
    "getThemeId",
    ()=>getThemeId,
    "isValidTheme",
    ()=>isValidTheme
]);
const SUPPORTED_THEMES = [
    "1",
    "2",
    "3",
    "4",
    "5",
    "6",
    "7"
];
const THEME_NAMES = {
    "1": "Theme 1",
    "2": "Theme 2",
    "3": "Theme 3",
    "4": "Theme 4",
    "5": "Theme 5",
    "6": "Theme 6",
    "7": "Theme 7"
};
const DEFAULT_THEME = "2";
function isValidTheme(id) {
    return SUPPORTED_THEMES.includes(id);
}
function getThemeId(id) {
    return isValidTheme(id) ? id : DEFAULT_THEME;
}
if (typeof globalThis.$RefreshHelpers$ === 'object' && globalThis.$RefreshHelpers !== null) {
    __turbopack_context__.k.registerExports(__turbopack_context__.m, globalThis.$RefreshHelpers$);
}
}),
"[project]/src/lib/color-theme.ts [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "getColorTheme",
    ()=>getColorTheme,
    "hexToRgba",
    ()=>hexToRgba
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$types$2f$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/src/types/theme.ts [app-client] (ecmascript)");
;
function getColorTheme(themeId) {
    const theme = (0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$types$2f$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["getThemeId"])(themeId);
    switch(theme){
        case "1":
            return {
                buttonBadge: "#d95f8c",
                welcomeBonus: "#870339",
                cardBackground: "#0d0d0d"
            };
        case "2":
            return {
                buttonBadge: "#9f95e5",
                welcomeBonus: "#494d6d",
                cardBackground: "#010326"
            };
        case "3":
            return {
                buttonBadge: "#bf9f98",
                welcomeBonus: "#510f3d",
                cardBackground: "#00010d"
            };
        case "4":
            return {
                buttonBadge: "#8bd1c3",
                welcomeBonus: "#0388a6",
                cardBackground: "#14231d"
            };
        case "5":
            return {
                buttonBadge: "#cca097",
                welcomeBonus: "#592816",
                cardBackground: "#0d0d0d"
            };
        case "6":
            return {
                buttonBadge: "#f2bbc9",
                welcomeBonus: "#8082a6",
                cardBackground: "#282e40"
            };
        case "7":
            return {
                buttonBadge: "#c5c8d9",
                welcomeBonus: "#2f5973",
                cardBackground: "#470913"
            };
        default:
            return {
                buttonBadge: "#9f95e5",
                welcomeBonus: "#494d6d",
                cardBackground: "#010326"
            };
    }
}
function hexToRgba(hex, alpha) {
    const r = parseInt(hex.slice(1, 3), 16);
    const g = parseInt(hex.slice(3, 5), 16);
    const b = parseInt(hex.slice(5, 7), 16);
    return `rgba(${r}, ${g}, ${b}, ${alpha})`;
}
if (typeof globalThis.$RefreshHelpers$ === 'object' && globalThis.$RefreshHelpers !== null) {
    __turbopack_context__.k.registerExports(__turbopack_context__.m, globalThis.$RefreshHelpers$);
}
}),
"[project]/src/components/Header.tsx [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "Header",
    ()=>Header
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/next/dist/compiled/react/jsx-dev-runtime.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/next/dist/compiled/react/index.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$image$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/next/image.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$client$2f$app$2d$dir$2f$link$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/next/dist/client/app-dir/link.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/src/lib/color-theme.ts [app-client] (ecmascript)");
;
var _s = __turbopack_context__.k.signature();
"use client";
;
;
;
;
function Header({ siteInfo, translations, language, theme }) {
    _s();
    const [isMenuOpen, setIsMenuOpen] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useState"])(false);
    const colorTheme = (0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["getColorTheme"])(theme);
    const navLinks = [
        {
            href: "/",
            label: translations.navigation.home
        },
        {
            href: "/about",
            label: translations.navigation.about
        },
        {
            href: "/contact",
            label: translations.navigation.contact
        }
    ];
    return /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("header", {
        className: "sticky top-0 z-50 border-b backdrop-blur-md shadow-xl",
        style: {
            borderColor: (0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.buttonBadge, 0.2),
            background: `linear-gradient(to bottom right, rgba(0, 0, 0, 0.98), ${(0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.cardBackground, 0.95)}, rgba(0, 0, 0, 0.98))`,
            boxShadow: `0 20px 50px -10px rgba(0, 0, 0, 0.8), 0 0 0 1px ${(0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.buttonBadge, 0.1)}`
        },
        children: [
            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                className: "absolute inset-0",
                style: {
                    background: `radial-gradient(circle at 30% 20%, ${(0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.buttonBadge, 0.06)}, transparent 60%)`
                }
            }, void 0, false, {
                fileName: "[project]/src/components/Header.tsx",
                lineNumber: 39,
                columnNumber: 7
            }, this),
            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                className: "absolute inset-0",
                style: {
                    background: `radial-gradient(circle at 70% 80%, ${(0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.welcomeBonus, 0.04)}, transparent 60%)`
                }
            }, void 0, false, {
                fileName: "[project]/src/components/Header.tsx",
                lineNumber: 45,
                columnNumber: 7
            }, this),
            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                className: "absolute inset-0 bg-[linear-gradient(rgba(255,255,255,0.02)_1px,transparent_1px),linear-gradient(90deg,rgba(255,255,255,0.02)_1px,transparent_1px)] bg-[size:30px_30px] opacity-40"
            }, void 0, false, {
                fileName: "[project]/src/components/Header.tsx",
                lineNumber: 53,
                columnNumber: 7
            }, this),
            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                className: "relative mx-auto flex max-w-6xl items-center justify-between px-4 py-4 sm:px-6 sm:py-5",
                children: [
                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$client$2f$app$2d$dir$2f$link$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["default"], {
                        href: "/",
                        className: "group flex items-center gap-2.5 sm:gap-3 transition-opacity hover:opacity-90",
                        children: [
                            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                className: "relative flex-shrink-0",
                                children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                    className: "relative h-12 w-12 overflow-hidden rounded-xl border-2 bg-white p-1 shadow-md sm:shadow-lg transition-all duration-500 group-hover:scale-110 group-hover:shadow-xl sm:h-16 sm:w-16 sm:rounded-3xl sm:p-3",
                                    style: {
                                        borderColor: (0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.buttonBadge, 0.6),
                                        boxShadow: `0 4px 6px -1px ${(0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.buttonBadge, 0.2)}`
                                    },
                                    onMouseEnter: (e)=>{
                                        e.currentTarget.style.borderColor = (0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.buttonBadge, 0.8);
                                        e.currentTarget.style.boxShadow = `0 20px 25px -5px ${(0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.buttonBadge, 0.4)}`;
                                    },
                                    onMouseLeave: (e)=>{
                                        e.currentTarget.style.borderColor = (0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.buttonBadge, 0.6);
                                        e.currentTarget.style.boxShadow = `0 4px 6px -1px ${(0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.buttonBadge, 0.2)}`;
                                    },
                                    children: [
                                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                            className: "absolute -inset-2 rounded-xl sm:opacity-0 blur-md transition-all duration-500 group-hover:opacity-100 sm:rounded-3xl",
                                            style: {
                                                background: `linear-gradient(to right, ${(0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.buttonBadge, 0.15)}, ${(0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.buttonBadge, 0.10)}, ${(0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.buttonBadge, 0.15)})`
                                            }
                                        }, void 0, false, {
                                            fileName: "[project]/src/components/Header.tsx",
                                            lineNumber: 75,
                                            columnNumber: 15
                                        }, this),
                                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$image$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["default"], {
                                            src: siteInfo.siteLogo,
                                            alt: `${siteInfo.siteName} logo`,
                                            fill: true,
                                            className: "relative z-10 object-contain brightness-100 contrast-100",
                                            sizes: "(max-width: 640px) 48px, 64px",
                                            priority: true,
                                            fetchPriority: "high",
                                            quality: 85,
                                            unoptimized: !siteInfo.siteLogo.includes('logo.png')
                                        }, void 0, false, {
                                            fileName: "[project]/src/components/Header.tsx",
                                            lineNumber: 81,
                                            columnNumber: 15
                                        }, this)
                                    ]
                                }, void 0, true, {
                                    fileName: "[project]/src/components/Header.tsx",
                                    lineNumber: 59,
                                    columnNumber: 13
                                }, this)
                            }, void 0, false, {
                                fileName: "[project]/src/components/Header.tsx",
                                lineNumber: 58,
                                columnNumber: 11
                            }, this),
                            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                className: "flex flex-col",
                                children: [
                                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("span", {
                                        className: "text-lg font-bold tracking-tight text-white sm:text-xl",
                                        children: siteInfo.siteName
                                    }, void 0, false, {
                                        fileName: "[project]/src/components/Header.tsx",
                                        lineNumber: 95,
                                        columnNumber: 13
                                    }, this),
                                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("span", {
                                        className: "text-[10px] font-medium text-white/70 sm:text-xs",
                                        children: siteInfo.tagline
                                    }, void 0, false, {
                                        fileName: "[project]/src/components/Header.tsx",
                                        lineNumber: 98,
                                        columnNumber: 13
                                    }, this)
                                ]
                            }, void 0, true, {
                                fileName: "[project]/src/components/Header.tsx",
                                lineNumber: 94,
                                columnNumber: 11
                            }, this)
                        ]
                    }, void 0, true, {
                        fileName: "[project]/src/components/Header.tsx",
                        lineNumber: 56,
                        columnNumber: 9
                    }, this),
                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("button", {
                        type: "button",
                        onClick: ()=>setIsMenuOpen(!isMenuOpen),
                        className: "relative flex flex-col gap-1.5 rounded-xl border p-2.5 transition-all active:scale-95 sm:hidden focus-visible:outline focus-visible:outline-2 focus-visible:outline-offset-2",
                        style: {
                            borderColor: (0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.buttonBadge, 0.2),
                            backgroundColor: (0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.buttonBadge, 0.05)
                        },
                        onMouseEnter: (e)=>{
                            e.currentTarget.style.backgroundColor = (0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.buttonBadge, 0.1);
                            e.currentTarget.style.borderColor = (0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.buttonBadge, 0.3);
                        },
                        onMouseLeave: (e)=>{
                            e.currentTarget.style.backgroundColor = (0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.buttonBadge, 0.05);
                            e.currentTarget.style.borderColor = (0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.buttonBadge, 0.2);
                        },
                        onFocus: (e)=>{
                            e.currentTarget.style.outlineColor = colorTheme.buttonBadge;
                        },
                        "aria-label": translations.navigation.home,
                        "aria-expanded": isMenuOpen,
                        children: [
                            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("span", {
                                className: `h-0.5 w-5 origin-center rounded-full bg-white transition-all duration-300 ${isMenuOpen ? "translate-y-2 rotate-45" : ""}`
                            }, void 0, false, {
                                fileName: "[project]/src/components/Header.tsx",
                                lineNumber: 127,
                                columnNumber: 11
                            }, this),
                            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("span", {
                                className: `h-0.5 w-5 rounded-full bg-white transition-all duration-300 ${isMenuOpen ? "opacity-0" : "opacity-100"}`
                            }, void 0, false, {
                                fileName: "[project]/src/components/Header.tsx",
                                lineNumber: 132,
                                columnNumber: 11
                            }, this),
                            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("span", {
                                className: `h-0.5 w-5 origin-center rounded-full bg-white transition-all duration-300 ${isMenuOpen ? "-translate-y-2 -rotate-45" : ""}`
                            }, void 0, false, {
                                fileName: "[project]/src/components/Header.tsx",
                                lineNumber: 137,
                                columnNumber: 11
                            }, this)
                        ]
                    }, void 0, true, {
                        fileName: "[project]/src/components/Header.tsx",
                        lineNumber: 105,
                        columnNumber: 9
                    }, this),
                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("nav", {
                        className: "hidden items-center gap-2 text-sm font-semibold sm:flex",
                        children: navLinks.map((link)=>/*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$client$2f$app$2d$dir$2f$link$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["default"], {
                                href: link.href,
                                className: "relative rounded-xl px-4 py-2.5 text-white/90 transition-all duration-200 hover:text-white active:scale-95 sm:px-5 focus-visible:outline focus-visible:outline-2 focus-visible:outline-offset-2",
                                style: {
                                    outlineColor: colorTheme.buttonBadge
                                },
                                onMouseEnter: (e)=>{
                                    e.currentTarget.style.backgroundColor = (0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.buttonBadge, 0.2);
                                    e.currentTarget.style.boxShadow = `0 10px 15px -3px ${(0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.buttonBadge, 0.3)}`;
                                },
                                onMouseLeave: (e)=>{
                                    e.currentTarget.style.backgroundColor = 'transparent';
                                    e.currentTarget.style.boxShadow = 'none';
                                },
                                children: link.label
                            }, link.href, false, {
                                fileName: "[project]/src/components/Header.tsx",
                                lineNumber: 147,
                                columnNumber: 13
                            }, this))
                    }, void 0, false, {
                        fileName: "[project]/src/components/Header.tsx",
                        lineNumber: 145,
                        columnNumber: 9
                    }, this)
                ]
            }, void 0, true, {
                fileName: "[project]/src/components/Header.tsx",
                lineNumber: 55,
                columnNumber: 7
            }, this),
            isMenuOpen && /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("nav", {
                className: "relative border-t backdrop-blur-md sm:hidden",
                style: {
                    borderColor: (0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.buttonBadge, 0.2),
                    background: `linear-gradient(to bottom right, rgba(0, 0, 0, 0.98), ${(0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.cardBackground, 0.95)}, rgba(0, 0, 0, 0.98))`,
                    boxShadow: `0 20px 50px -10px rgba(0, 0, 0, 0.8), 0 0 0 1px ${(0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.buttonBadge, 0.1)}`
                },
                children: [
                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                        className: "absolute inset-0",
                        style: {
                            background: `radial-gradient(circle at 30% 20%, ${(0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.buttonBadge, 0.06)}, transparent 60%)`
                        }
                    }, void 0, false, {
                        fileName: "[project]/src/components/Header.tsx",
                        lineNumber: 180,
                        columnNumber: 11
                    }, this),
                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                        className: "absolute inset-0",
                        style: {
                            background: `radial-gradient(circle at 70% 80%, ${(0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.welcomeBonus, 0.04)}, transparent 60%)`
                        }
                    }, void 0, false, {
                        fileName: "[project]/src/components/Header.tsx",
                        lineNumber: 186,
                        columnNumber: 11
                    }, this),
                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                        className: "relative mx-auto flex max-w-6xl flex-col gap-1 px-4 py-3",
                        children: navLinks.map((link)=>/*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$client$2f$app$2d$dir$2f$link$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["default"], {
                                href: link.href,
                                onClick: ()=>setIsMenuOpen(false),
                                className: "rounded-xl px-4 py-3 text-sm font-semibold text-white transition-all duration-200 active:scale-[0.98] focus-visible:outline focus-visible:outline-2 focus-visible:outline-offset-2",
                                style: {
                                    outlineColor: colorTheme.buttonBadge
                                },
                                onMouseEnter: (e)=>{
                                    e.currentTarget.style.backgroundColor = (0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.buttonBadge, 0.2);
                                    e.currentTarget.style.boxShadow = `0 10px 15px -3px ${(0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$color$2d$theme$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hexToRgba"])(colorTheme.buttonBadge, 0.3)}`;
                                },
                                onMouseLeave: (e)=>{
                                    e.currentTarget.style.backgroundColor = 'transparent';
                                    e.currentTarget.style.boxShadow = 'none';
                                },
                                children: link.label
                            }, link.href, false, {
                                fileName: "[project]/src/components/Header.tsx",
                                lineNumber: 194,
                                columnNumber: 15
                            }, this))
                    }, void 0, false, {
                        fileName: "[project]/src/components/Header.tsx",
                        lineNumber: 192,
                        columnNumber: 11
                    }, this)
                ]
            }, void 0, true, {
                fileName: "[project]/src/components/Header.tsx",
                lineNumber: 171,
                columnNumber: 9
            }, this)
        ]
    }, void 0, true, {
        fileName: "[project]/src/components/Header.tsx",
        lineNumber: 30,
        columnNumber: 5
    }, this);
}
_s(Header, "vK10R+uCyHfZ4DZVnxbYkMWJB8g=");
_c = Header;
var _c;
__turbopack_context__.k.register(_c, "Header");
if (typeof globalThis.$RefreshHelpers$ === 'object' && globalThis.$RefreshHelpers !== null) {
    __turbopack_context__.k.registerExports(__turbopack_context__.m, globalThis.$RefreshHelpers$);
}
}),
]);

//# sourceMappingURL=src_86966b90._.js.map