# Deployment Guide

## File Upload Permissions

This application requires write permissions for the following directories:

### Required Directories
- `public/` - For site logo and favicon uploads
- `public/logos/` - For partner logo uploads

### Setting Permissions

Before deploying, ensure these directories have proper write permissions:

```bash
# Set directory permissions (755 = rwxr-xr-x)
chmod 755 public
chmod 755 public/logos

# Ensure the directories exist
mkdir -p public/logos
```

### Production Server Setup

#### Option 1: Automated Setup (Recommended)
Run the setup script after deployment:
```bash
npm run setup
# or
node setup-upload-dirs.js
```

This will automatically:
- Create required directories (`public/`, `public/logos/`, `data/`)
- Set proper permissions (755 for directories)

#### Option 2: Manual Setup
1. **Create directories** (if they don't exist):
   ```bash
   mkdir -p public/logos
   ```

2. **Set permissions**:
   ```bash
   # Directories need execute permission (755)
   chmod 755 public
   chmod 755 public/logos
   
   # Files will be created with 644 permissions automatically
   ```

3. **Verify ownership**:
   ```bash
   # Ensure the web server user owns the directories
   # Replace 'www-data' with your server user (nginx, apache, etc.)
   chown -R www-data:www-data public
   ```

### Common Hosting Platforms

#### Vercel / Netlify
- No action needed - permissions are handled automatically

#### Traditional VPS/Shared Hosting
- Run the permission commands above via SSH
- Contact your hosting provider if you don't have SSH access

#### Docker
- Ensure volumes are mounted with proper permissions
- The Node.js process user should have write access

### Troubleshooting

If uploads fail with permission errors:

1. Check directory exists:
   ```bash
   ls -la public/
   ls -la public/logos/
   ```

2. Check permissions:
   ```bash
   ls -ld public/
   ls -ld public/logos/
   ```

3. Check ownership:
   ```bash
   ls -la public/ | head
   ```

4. Test write access:
   ```bash
   touch public/test.txt && rm public/test.txt
   ```

### File Permissions Reference

- **755** (directories): Owner can read/write/execute, others can read/execute
- **644** (files): Owner can read/write, others can read only

