import type { Partner, SiteInfo } from "@/types/data";
import {
  generateOrganizationLd,
  generateItemListLd,
  generateReviewLd,
} from "@/lib/structured-data";

interface StructuredDataProps {
  readonly siteInfo: SiteInfo;
  readonly licensedPartners: readonly Partner[];
}

/**
 * Server component for structured data (JSON-LD)
 * Renders schema.org structured data for SEO
 */
export function StructuredData({ siteInfo, licensedPartners }: StructuredDataProps) {
  const organizationLd = generateOrganizationLd(siteInfo);
  const itemListLd = generateItemListLd(licensedPartners, siteInfo.siteName);
  const reviewLd = generateReviewLd(licensedPartners[0], siteInfo.siteName);

  return (
    <>
      <script
        type="application/ld+json"
        suppressHydrationWarning
        dangerouslySetInnerHTML={{ __html: JSON.stringify(organizationLd) }}
      />
      <script
        type="application/ld+json"
        suppressHydrationWarning
        dangerouslySetInnerHTML={{ __html: JSON.stringify(itemListLd) }}
      />
      {reviewLd && (
        <script
          type="application/ld+json"
          suppressHydrationWarning
          dangerouslySetInnerHTML={{ __html: JSON.stringify(reviewLd) }}
        />
      )}
    </>
  );
}

