export interface SiteInfo {
  readonly siteName: string;
  readonly siteLogo: string;
  readonly email: string;
  readonly address: string;
  readonly phone: string;
  readonly accountCode: string;
  readonly tagline: string;
  readonly favicon: string;
  readonly browserTitle: string;
  readonly defaultLanguage?: string; // Site-wide default language (optional for backward compatibility)
  readonly defaultTheme?: string; // Site-wide default theme (optional for backward compatibility)
}

export interface Partner {
  readonly name: string;
  readonly logo: string;
  readonly welcomeBonus: string;
  readonly affiliateLink: string;
  readonly licensed: boolean;
  readonly rating: number;
  readonly display?: boolean; // Whether this partner should be displayed on the site
}

export type SearchParams = Record<string, string | string[] | undefined>;
