export type ThemeId = "1" | "2" | "3" | "4" | "5" | "6" | "7";

export const SUPPORTED_THEMES: readonly ThemeId[] = ["1", "2", "3", "4", "5", "6", "7"] as const;

export const THEME_NAMES: Record<ThemeId, string> = {
  "1": "Theme 1",
  "2": "Theme 2",
  "3": "Theme 3",
  "4": "Theme 4",
  "5": "Theme 5",
  "6": "Theme 6",
  "7": "Theme 7",
};

export const DEFAULT_THEME: ThemeId = "2";

export function isValidTheme(id: string | null | undefined): id is ThemeId {
  return SUPPORTED_THEMES.includes(id as ThemeId);
}

/**
 * Gets theme ID from string, falls back to default
 */
export function getThemeId(id: string | null | undefined): ThemeId {
  return isValidTheme(id) ? id : DEFAULT_THEME;
}

